<?php
/**
 * TitanEcho
 * @author Titan Systems <mail@titansystems.ph>
 * @description Library for communicating with TitanEcho
 */

class MVC_Library_Echo
{
	public $_cache = false;
	public $_guzzle = false;

	public function token($refreshOldToken = false, $check = false)
	{
		$this->_cache->container("system.echo", true);

		if($refreshOldToken):
			try {
				json_decode($this->_guzzle->get(titansys_api . "/echo/delete", [
					"headers" => [
						"Titan-Code" => system_purchase_code,
						"Titan-Token" => $refreshOldToken
					],
	                "allow_redirects" => true,
	                "http_errors" => false
	            ])->getBody()->getContents());

	            $this->_cache->delete("token");
			} catch(Exception $e){
				return false;
			}
		else:
			if($check):
				if($this->_cache->has("token")):
					try {
						$check = json_decode($this->_guzzle->get(titansys_api . "/echo/check", [
							"headers" => [
								"Titan-Code" => system_purchase_code,
								"Titan-Token" => $this->_cache->get("token")
							],
			                "allow_redirects" => true,
			                "http_errors" => false
			            ])->getBody()->getContents());

			            if($check->status == 500):
			            	$this->_cache->delete("token");
			            endif;
					} catch(Exception $e){
						return false;
					}
				endif;
			endif;
		endif;

		if(!$this->_cache->has("token")):
			try {
				$token = json_decode($this->_guzzle->get(titansys_api . "/echo/token", [
					"headers" => [
						"Titan-Code" => system_purchase_code,
						"Titan-Site" => site_url
					],
	                "allow_redirects" => true,
	                "http_errors" => false
	            ])->getBody()->getContents());

	            if($token->status == 200):
	            	$this->_cache->set("token", $token->data->token);
	            else:
	            	return false;
	            endif;
			} catch(Exception $e){
				return false;
			}
		endif;

		return $this->_cache->get("token");
	}

	public function notify($name, $content, $volatile = false)
	{
		$token = $this->token();

		try {
			$notify = json_decode($this->_guzzle->post(titansys_api . "/echo/notify", [
				"headers" => [
					"Titan-Code" => system_purchase_code,
					"Titan-Token" => $token
				],
				"form_params" => [
					"name" => $name,
					"content" => $content,
					"volatile" => $volatile
				],
                "allow_redirects" => true,
                "http_errors" => false
            ])->getBody()->getContents());

            if($notify->status == 200):
            	return true;
            else:
            	return false;
            endif;
		} catch(Exception $e){
			return false;
		}
	}
}